import {defineConfig} from 'vite'
import vue from '@vitejs/plugin-vue'
import {resolve} from 'path'

export default defineConfig({
    plugins: [vue()],
    resolve: {
        alias: {
            '@': resolve(__dirname, 'src')
        }
    },
    server: {
        host: '0.0.0.0', // 确保监听所有网络接口
        port: 3001,
        open: true,
        strictPort: false, // 如果端口被占用，尝试其他端口
        cors: true, // 启用 CORS
        // 明确指定网络接口
        hmr: {
            host: 'localhost',
            protocol: 'ws'
        },
        // 代理配置解决跨域问题
        proxy: {
            '/api': {
                target: 'https://service.wanyouziyu.com/', // 替换为您的实际API域名
                changeOrigin: true,
                secure: true, // 如果是https接口，需要配置这个参数
                rewrite: (path) => path.replace(/^\/api/, '') // 可选：重写路径
            }
        }
    }
})
