# 企业官网

基于 Vue 3 + Element Plus + Vite + JavaScript 构建的现代化企业官网。

## 技术栈

- **Vue 3** - 渐进式 JavaScript 框架
- **Element Plus** - Vue 3 组件库
- **Vite** - 下一代前端构建工具
- **Vue Router** - Vue.js 官方路由管理器

## 项目结构

```
├── public/                 # 静态资源
├── src/
│   ├── components/         # 组件
│   │   ├── Layout.vue     # 布局组件
│   │   ├── Header.vue     # 头部组件
│   │   └── Footer.vue     # 底部组件
│   ├── views/             # 页面
│   │   └── Home.vue       # 首页
│   ├── router/            # 路由配置
│   │   └── index.js
│   ├── App.vue            # 根组件
│   ├── main.js            # 入口文件
│   └── style.css          # 全局样式
├── index.html             # HTML 模板
├── package.json           # 项目配置
├── vite.config.js         # Vite 配置
└── README.md              # 项目说明
```

## 功能特性

- ✅ 响应式布局设计
- ✅ 现代化 UI 界面
- ✅ 轮播图展示
- ✅ 产品服务展示
- ✅ 新闻动态
- ✅ 公司介绍
- ✅ 联系方式
- ✅ 移动端适配

## 快速开始

### 安装依赖

```bash
npm install
```

### 启动开发服务器

```bash
npm run dev
```

### 构建生产版本

```bash
npm run build
```

### 预览生产版本

```bash
npm run preview
```

## 页面布局

项目采用经典的头部 + 内容 + 底部布局：

- **头部 (Header)**: 包含 Logo、导航菜单和操作按钮
- **内容区 (Main Content)**: 根据页面内容自适应高度，最小高度为 100vh
- **底部 (Footer)**: 包含公司信息、快速链接、联系方式和社交媒体

## 自定义配置

### 修改公司信息

在 `src/components/Header.vue` 和 `src/components/Footer.vue` 中修改公司名称、联系方式等信息。

### 添加新页面

1. 在 `src/views/` 目录下创建新的 Vue 组件
2. 在 `src/router/index.js` 中添加路由配置
3. 在 `src/components/Header.vue` 中添加导航菜单项

### 自定义样式

- 全局样式：修改 `src/style.css`
- 组件样式：在各组件的 `<style>` 标签中修改

## 浏览器支持

- Chrome >= 87
- Firefox >= 78
- Safari >= 14
- Edge >= 88

## 许可证

MIT License
