import {
	createRouter,
	createWebHistory
} from 'vue-router'
import Layout from '@/components/Layout.vue'
import Case from '@/views/Case.vue'
import Cooperation from '@/views/Cooperation.vue'
import Product from '@/views/Product.vue'
import Serve from '@/views/Serve.vue'
import lease from '@/views/lease.vue'
import operator from '@/views/operator.vue'
import agent from '@/views/agent.vue'
import certification from '@/views/certification.vue'
import contactUs from '@/views/contact-us.vue'
import brand from '@/views/brand.vue'
import homepage from '@/views/homepage.vue'

const routes = [{
	path: '/',
	component: Layout,
	children: [{
			path: '',
			name: 'homepage',
			component: homepage
		},
		{
			path: 'brand',
			name: 'brand',
			component: brand
		},
		{
			path: 'serve',
			name: 'serve',
			component: Serve
		},
		{
			path: 'cooperation',
			name: 'cooperation',
			component: Cooperation
		},
		{
			path: 'certification',
			name: 'certification',
			component: certification
		},
		{
			path: 'contact-us',
			name: 'contact-us',
			component: contactUs
		},
		{
			path: 'agent',
			name: 'agent',
			component: agent
		},
		{
			path: 'operator',
			name: 'operator',
			component: operator
		},
		{
			path: 'lease',
			name: 'lease',
			component: lease
		},
		{
			path: 'Product',
			name: 'Product',
			component: Product
		},
		{
			path: 'case',
			name: 'case',
			component: Case
		}
	]
}]

const router = createRouter({
	history: createWebHistory(),
	routes,
	// 添加滚动行为，确保每次路由切换都滚动到顶部
	scrollBehavior(to, from, savedPosition) {
		// 如果有保存的位置（比如用户点击浏览器的前进/后退按钮），则恢复到该位置
		if (savedPosition) {
			return savedPosition
		}
		// 否则滚动到页面顶部
		return {
			top: 0
		}
	}
})

export default router