import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path'

export default defineConfig({
    plugins: [vue()],
    resolve: {
        alias: {
            '@': resolve(__dirname, 'src')
        }
    },
    server: {
        host: '0.0.0.0', // 确保监听所有网络接口
        port: 3001,
        open: true,
        strictPort: false, // 如果端口被占用，尝试其他端口
        cors: true, // 启用 CORS
        // 明确指定网络接口
        hmr: {
            host: 'localhost',
            protocol: 'ws'
        },
    }
})
